/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.vein;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.stone.BlockOreTFC;
import net.dries007.tfc.world.classic.worldgen.vein.Vein;
import net.dries007.tfc.world.classic.worldgen.vein.VeinCluster;
import net.dries007.tfc.world.classic.worldgen.vein.VeinSphere;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class VeinType {
    private final Ore ore;
    private final ItemStack looseRock;
    private final Set<Rock> baseRocks;
    private final int width;
    private final int height;
    private final int minY;
    private final int maxY;
    private final double weight;
    private final double density;
    private final int rarity;
    private final Shape shape;
    private String name;

    public VeinType(@Nullable Ore ore, ItemStack looseRock, Collection<Rock> baseRocks, Shape shape, int width, int height, int rarity, int minY, int maxY, int density) {
        this.ore = ore;
        this.looseRock = looseRock;
        this.baseRocks = ImmutableSet.copyOf(baseRocks);
        this.shape = shape;
        this.width = width;
        this.height = height;
        this.rarity = rarity;
        this.weight = 1.0 / (double)rarity;
        this.minY = minY;
        this.maxY = maxY;
        this.density = 0.006 * (double)density;
    }

    public Vein createVein(Random rand, int chunkX, int chunkZ) {
        BlockPos startPos = new BlockPos(chunkX * 16 + 8 + rand.nextInt(16), this.minY + rand.nextInt(this.maxY - this.minY), chunkZ * 16 + 8 + rand.nextInt(16));
        Ore.Grade grade = Ore.Grade.NORMAL;
        if (this.ore != null && this.ore.isGraded()) {
            float randomGrade = rand.nextFloat();
            if ((double)randomGrade < 0.2) {
                grade = Ore.Grade.RICH;
            } else if ((double)randomGrade < 0.5) {
                grade = Ore.Grade.POOR;
            }
        }
        switch (this.shape) {
            case SPHERE: {
                return new VeinSphere(startPos, this, grade, rand);
            }
            case CLUSTER: {
                return new VeinCluster(startPos, this, grade, rand);
            }
        }
        throw new IllegalStateException("Shape is missing!");
    }

    public boolean isOreBlock(IBlockState state) {
        return state.func_177230_c() instanceof BlockOreTFC && ((BlockOreTFC)state.func_177230_c()).ore == this.getOre();
    }

    public IBlockState getOreState(Rock rock, Ore.Grade grade) {
        return BlockOreTFC.get(this.ore, rock, grade);
    }

    public boolean hasLooseRocks() {
        return !this.looseRock.func_190926_b();
    }

    @Nonnull
    public ItemStack getLooseRockItem() {
        return this.looseRock.func_77946_l();
    }

    public String getRegistryName() {
        return this.name;
    }

    public void setRegistryName(String name) {
        this.name = name;
    }

    public String toString() {
        String ore = "special";
        if (this.getOre() != null) {
            ore = this.getOre().toString();
        } else if (this.getOreState(Rock.GRANITE, Ore.Grade.NORMAL) != null) {
            ore = this.getOreState(Rock.GRANITE, Ore.Grade.NORMAL).func_177230_c().getRegistryName().toString();
        }
        return String.format("%s: {ore=%s, shape=%s, size=%s, rarity=%d, baseRocks=%s, minY=%d, maxY=%d, density=%.2f}", new Object[]{this.name, ore, this.shape, this.getWidth(), this.getRarity(), this.baseRocks, this.getMinY(), this.getMaxY(), this.getDensity()});
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getDensity() {
        return this.density;
    }

    public int getRarity() {
        return this.rarity;
    }

    public Ore getOre() {
        return this.ore;
    }

    public boolean canSpawnIn(Rock rock) {
        return this.baseRocks.contains((Object)rock);
    }

    public static class CustomVeinType
    extends VeinType {
        private final IBlockState oreState;

        public CustomVeinType(@Nonnull IBlockState oreState, ItemStack looseRock, @Nonnull Collection<Rock> rocks, Shape shape, int width, int height, int rarity, int minY, int maxY, int density) {
            super(null, looseRock, rocks, shape, width, height, rarity, minY, maxY, density);
            this.oreState = oreState;
        }

        @Override
        public boolean isOreBlock(IBlockState state) {
            return state == this.oreState;
        }

        @Override
        public IBlockState getOreState(Rock rock, Ore.Grade grade) {
            return this.oreState;
        }
    }

    public static enum Shape {
        SPHERE,
        CLUSTER;

    }
}

